//
//  NotificationService.swift
//  FusionNotificationServiceExtension
//
//  Created by Hao Nguyen on 5/22/19.
//  Copyright © 2019 GeoComply. All rights reserved.
//

import UserNotifications
import CoreLocation
import GeoComplySDK
import GeoComplyOobee

class NotificationService: UNNotificationServiceExtension {

    var contentHandler: ((UNNotificationContent) -> Void)?
    var bestAttemptContent: UNMutableNotificationContent?

    var oobee = OobeeLibrary()

    override func didReceive(_ request: UNNotificationRequest, withContentHandler contentHandler: @escaping (UNNotificationContent) -> Void) {
        self.contentHandler = contentHandler
        bestAttemptContent = (request.content.mutableCopy() as? UNMutableNotificationContent)
        
        if let bestAttemptContent = bestAttemptContent {
            // Modify the notification content here...

            self.oobee.processOobeeAPN(bestAttemptContent.userInfo, completionHandler: { (error, success) in
                print(error ?? "no error")
                bestAttemptContent.title = "OobeeFusion has finished geolocation"
                bestAttemptContent.body = "Please go back to your browser to continue"
                contentHandler(bestAttemptContent)
            })

        }
    }
    
    override func serviceExtensionTimeWillExpire() {
        // Called just before the extension will be terminated by the system.
        // Use this as an opportunity to deliver your "best attempt" at modified content, otherwise the original push payload will be used.
        if let contentHandler = contentHandler, let bestAttemptContent =  bestAttemptContent {
            bestAttemptContent.title = "Geolocation timeout"
            bestAttemptContent.body = "Please try again"
            contentHandler(bestAttemptContent)
        }
    }

}
