//
//  CommunicationController+Synchronously.h
//  OobeeLibrary
//
//  Created by KennyHo on 6/5/15.
//  Copyright (c) 2015 Geocomply. All rights reserved.

//  ==================================================================================
//  Those functions are used to serve requests from web app to Oobee local HTTP server
//  ==================================================================================

#import "CommunicationController.h"
#import "OobeeAPIClient.h"

@interface CommunicationController (Synchronously)


-(NSString*) processSocketPackageSynchronously:(NSURL*)url Requester:(id<OobeeLibraryDelegate>)requester Error:(NSError **) error;
-(NSString*)pairDeviceSynchronouslyForRequestFromWebAppWithPairCode:(NSString*)pairCode Requester:(id<OobeeLibraryDelegate>)requester;
-(NSString*)proximityCheckDeviceSynchronouslyForRequestFromWebAppWithPairCode:(NSString*)pairCode andDeviceUUID:(NSString*)device_uuid Requester:(id<OobeeLibraryDelegate>)requester;
-(void)putGeolocationFailResultSynchronously:(NSDictionary*)dataDict toURL:(NSString*)urlString returnError:(NSError**)error;
-(void)synchronizeWithServerSynchronously:(NSString*) deviceTokenId returnError:(NSError**)error;
-(NSString*)httpRequestSynchronouslyWithMethod:(NSString*)method bodyDic:(NSDictionary*)dataDictionary toURLString:(NSString*)urlString;
@end
