//
//  CommunicationController.h
//  Oobee
//
//  Created by geotech on 6/12/14.
//  Copyright (c) 2014 Geocomply. All rights reserved.
//

#define RegisterDelegateKey @"RegisterDelegateKey"
#define PairDeviceDelegateKey @"PairDeviceDelegateKey"
#define KDataDictionary     @"dataDictionary"
#define KToUrlAddress       @"toUrlAddress"
#define KAction             @"action"
#define KRequesterObject    @"requesterObject"

#define HTTP_REQ_TIMEOUT    30
#define COLOR_DEPTH         32


#import <Foundation/Foundation.h>
#import "Setting.h"
#import "OobeeLibrary.h"
#import "RequesterObject.h"
#import <GeoComplySDK/GeoComplySDK.h>
#import "Reachability.h"
#import "Setting.h"
#import "AdvancedMerchants.h"
#import "CoreDataUtil.h"
#import "Merchant.h"
#import "RequesterObject.h"
#import "OobeeError.h"
#import "Error.h"
#import <UIKit/UIKit.h>
#import "URLParser.h"
#import "OobeeAPIObject.h"

typedef void (^OobeeRequestHandler)(NSData*, NSError*);


@interface CommunicationController : NSObject <GCClientDelegate>{

    NSString * previousPayloadUrl;
    NSString * previousProximityUrl;
    NSString* currentGeolocationObjectUrl;
    GeoComplyClient* gcClient;
    NSString * deviceToken;
    BOOL isGettingPayload;
    NSMutableArray * getPayloadRequestQueue;
#define kLISENCE_STRING @"kLISENCE_STRING"
#define kCALL_BACK_URL @"kCALL_BACK_URL"
    
    NSMutableDictionary * pendingProximitySubmission;
    NSDictionary * frameDevice;
    Reachability* hostReach;
    NSMutableSet *failedPendingQueue;
    
}

/**
 *  Call to register the device with APN service
 *
 *  @param deviceTokenId the device token ID used for push notification
 *  @param requester     the address of object which calls this method. The result of action will be return to this address
 */
-(NSError *) registerDeviceWithOobeeServer:(NSString *)deviceTokenId Requester:(id<OobeeLibraryDelegate>)callerObject;

/**
 *  Call to register device with guvnr server
 *
 *  @param pairCode  the pair code used to register device
 *  @param requester the address of object which calls this method
 */
-(NSError *) pairDevice: (NSString*) pairCode  Requester:(id<OobeeLibraryDelegate>) callerObject;

/**
 *  call this to register device with guvnr server
 *
 *  @param pairCode     the pair code used to register device
 *  @param deviceUID    deviceUID is used in case of submiting pair code for proximity checking
 *  @param callerObject the address of object which calls this method
 *  @param pairType     the type of pairing action (proximity / first pair)
 */
-(NSError *) pairDevice: (NSString*) pairCode deviceUID:(NSString*)deviceUID
    Requester:(id<OobeeLibraryDelegate>) callerObject
                      Type:(PairType) pairType;

/**
 *  call this to get a frame device then combine it with pair code
 *  @param: non
 *  return: dataFrame   the data frame under dictionary type :
    {
        "os": "iOS 7.1.2",
        "time_zone": 420,
        "cpu_cores": 2,
        "resolution": "320x240",
        "color_depth": 16
    }
 */
- (NSDictionary*) getFrame;


/**
 *  Call this function to process the http response message
 *
 *  @param data            the data responsed
 *  @param fromUrl         the address of responsed data
 *  @param requesterObject the address of object which calls this method
 */
-(NSError *) processReponseMessage: (NSData *) data fromUrl:(NSURL*)fromUrl RequesterObject:(RequesterObject*) requesterObject;

/**
 *  Call to process the push notification data
 *
 *  @param data the data of push notification
 *
 *  @return YES if processing sucessful/ NO if processing failed
 */

/**
 *    Call to process the push notification data
 *
 *    @param data      the data of push notification

 *    @param callerObject the address of object which calls this method
 *
 *    @return YES if processing sucessful/ NO if processing failed
 */
-(NSError *) processRemoteNotification:(NSDictionary*) data
                        Requester:(id<OobeeLibraryDelegate>)callerObject;

/**
 *  Call to submit geolocation to server
 *
 *  @param geolocationData data of geolocation
 */
-(NSError *)  submitGeolocationData:(NSString*) geolocationData toURL:(NSString *)url;

/**
 *  call this function to unregister this device with
 *
 *  @param deviceUID    deviceUID used to specify the client to unregister
 *  @param callerObject the address of object which calls this method
 */
-(NSError *) unPairDevice:(NSString*) deviceUID
Requester:(id<OobeeLibraryDelegate>) callerObject;

/**
 *  Call to get singleton instance of CommunicationController object
 *
 *  @return return the address of instance
 */
+ (id) GetInstance;

/**
 *  call the log out the NSdata message
 *
 *  @param data data to be logged
 *  @param Msg  message description for data
 */
- (void) logNSData:(NSData *) data
        LogMessage:(NSString *) Msg;


-(NSError *) sendData:(NSDictionary *)dataDictionary toUrl:(NSString*)toUrlAddress action:(NSString*)action RequesterObject:(RequesterObject*) requesterObject;

-(NSError*) processGeolocationPayload:(NSDictionary*) geolocationPayload Requester:(id<OobeeLibraryDelegate>)requester;
-(NSError*) processProximityPayload:(NSDictionary*) proximityPayload Requester:(id<OobeeLibraryDelegate>)requester;
-(NSError*) processUnpairPayload:(NSDictionary*) unPairPayload Requester:(id<OobeeLibraryDelegate>)requester;
-(NSError*) requestGeolocation:(NSString*)licenseString;
-(NSError *)  synchronizeWithServer:(NSString*) deviceToken;

/**
 *    Process package from socket client
 *
 *    @param url   called URL
 *    @param error error returned if any
 *
 *    @return return the content of replication to client
 */
-(NSString*) processSocketPackage:(NSURL*) url Requester:(id<OobeeLibraryDelegate>)requester Error:(NSError **) error;


//Internal methods
-(NSError *) requestProximityPayload:(NSString *) deviceUid;
-(NSError*) processNextGeolocationRequest;
@end

