//
//  Merchant.h
//  oobeeLibrary
//
//  Created by geotech on 7/23/14.
//  Copyright (c) 2014 Geocomply. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>

@class AdvancedMerchants;

@interface Merchant : NSObject
/**
 *  Ther merchant name
 */
@property (nonatomic, retain) NSString * merchantName;

/**
 *  The ID of merchant
 */
@property (nonatomic, retain) NSString * merchantID;

/**
 *  The paired time of merchant
 */
@property (nonatomic, retain) NSDate * pairedOnDate;

/**
 *  Last proximity checking of the merchant
 */
@property (nonatomic, retain) NSDate * lastProximityCheckingDate;

/**
 *  Device UID
 */
@property (nonatomic, retain) NSString * deviceUID;

/**
 *    The algorithm for pair/proximity checking (paircode/ultrasound/qrcode)
 */
@property (nonatomic, retain) NSString * algorithm;


/**
 *    Constructor
 *    @param merchantName              Merchant name
 *    @param merchantID                Merchant Id
 *    @param pairedOnDate              the time of pairing
 *    @param lastProximityCheckingDate Last proximity checking
 *    @param deviceUID                 device Uid
 *
 *    @return return the Merchant object
 */
- (id) init:(NSString*) merchantName merchantID:(NSString *) merchantID
pairedOnDate:(NSDate *) pairedOnDate
lastProximityCheckingDate:(NSDate *) lastProximityCheckingDate
  deviceUID:(NSString *) deviceUID
  algorithm:(NSString*) algorithm;


@end
