//
//  OobeeDevice.h
//  OobeeLibrary
//
//  Created by Hao Nguyen on 5/30/17.
//  Copyright © 2017 Geocomply. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "Setting.h"

//#ifdef DEBUG
#define trace() NSLog(@"%s", __FUNCTION__)
//#else
//#define trace()
//#endif

#define kLISENCE_STRING @"kLISENCE_STRING"
#define kCALL_BACK_URL @"kCALL_BACK_URL"

typedef void (^OobeeDeviceHandler) (NSData* data, NSError* error);

typedef NS_ENUM(NSInteger, OobeeAlertType) {
    OobeeAlertTypeRegister,
    OobeeAlertTypePair,
    OobeeAlertTypeProximity,
    OobeeAlertTypeGeolocation
};

@interface NSJSONSerialization (GCJSON)

+ (id)gc_dataWith:(id)json;
+ (id)gc_jsonWith:(NSData*)data;

@end

@interface OobeeDevice : NSObject

+ (NSDictionary*)frame;
+ (void)geolocation:(NSData*)data handler:(OobeeDeviceHandler)handler;
+ (void)alert:(OobeeAlertType)type error:(NSError*)error;

@end
