//
//  OobeeNetworkKit.h
//  OobeeLibrary
//
//  Created by Hao Nguyen on 5/26/17.
//  Copyright © 2017 Geocomply. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OobeeDevice.h"
#import "OobeeError.h"
#import "AdvancedMerchants.h"

typedef void (^OobeeNetworkHandler) (NSData* data);

@interface OobeeNetworkKit : NSObject

+ (void)accept:(NSURL*)url handler:(OobeeNetworkHandler)handler;

@end

typedef void (^OobeeUtilityHandler) (NSData* data, NSError* error);

@interface OobeeUtilities : NSObject

+ (void)registerDevice:(NSString*)token to:(NSURL*)server hanlder:(OobeeUtilityHandler)handler;
+ (void)pair:(NSString*)pairCode to:(NSURL*)server handler:(OobeeUtilityHandler)handler;
+ (void)sync:(NSString*)token to:(NSURL*)server handler:(OobeeUtilityHandler)handler;
+ (void)proximity:(NSString*)pairCode uuid:(NSString*)uuid to:(NSURL*)server handler:(OobeeUtilityHandler)handler;
+ (void)geolocation:(NSDictionary*)payload handler:(OobeeUtilityHandler)handler;
+ (void)unpair:(NSString*)uuid to:(NSURL*)server handler:(OobeeUtilityHandler)handler;

+ (void)syncToken:(NSString*)newToken handler:(OobeeUtilityHandler)handler;
+ (BOOL)isFirstLaunch;
+ (NSString*)getCurrentAppVersion;


@end

typedef void (^OobeeAPIHandler) (NSData* data, NSHTTPURLResponse* response, NSError* error);

@interface OobeeAPIKit : NSObject

+ (void)api_put:(NSData*)data to:(NSURL*)url handler:(OobeeAPIHandler)handler;
+ (void)api_post:(NSData*)data to:(NSURL*)url handler:(OobeeAPIHandler)handler;
+ (void)api_get:(NSURL*)url handler:(OobeeAPIHandler)handler;
+ (void)api_delete:(NSData*)data to:(NSURL*)url handler:(OobeeAPIHandler)handler;
+ (void)method:(NSString*)method data:(NSData*)data to:(NSURL*)url handler:(OobeeAPIHandler)handler;
@end
