//
//  FirstViewController.swift
//  OobeeFusion
//
//  Created by Hao Nguyen on 4/1/19.
//  Copyright © 2019 GeoComply. All rights reserved.
//

import UIKit
import GeoComplySDK
import GeoComplyOobee

class SDKViewController: UIViewController {
    
    var sdk = GeoComplyClient.instance()
    let token = "license string"

    @IBOutlet weak var oobeePortTxtField: UITextField!

    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view.
        initGeoComplySDK()
        self.oobeePortTxtField.text = "48870"
    }

    func initGeoComplySDK() {
        sdk.delegate = self
        sdk.userId = "OobeeFusion-SDK"
        sdk.geolocationReason = "OobeeFusion"
        sdk.userPhoneNumber = "012345679"
        do {
            try sdk.setLicense(token)
        } catch {
            print("Set License Error: \(error)")
        }
    }
    
    @IBAction func requestGeolocationBtnPressed(_ sender: Any) {
        do {
            try sdk.requestGeolocation()
        } catch {
            print("Request Geolocation Error: \(error)")
        }
    }
    @IBAction func setOobeePort(_ sender: Any) {
        if oobeePortTxtField.isFirstResponder {
            oobeePortTxtField.resignFirstResponder()
        }
        self.oobeePortTxtField.text = "\(oobeePortTxtField.text!)"
        let appDelegate = UIApplication.shared.delegate as! AppDelegate
        appDelegate.stopOobeeServer()
        appDelegate.initOobeeOnPort(Int(oobeePortTxtField.text!)!)
    }
}

extension SDKViewController: GCClientDelegate {
    func didGeolocationFailed(_ error: GCError) {
        print("SDK Failed: \(String(describing: error.description))")
    }
    
    func didGeolocationAvailable(_ data: String) {
        print("SDK Data: \(data)")
    }
    
    func didStopUpdating(_ info: [AnyHashable : Any]?) {
        print("didStopUpdating")
    }
    
    func updateLog(_ message: String) {
        print("GeoComplySDK: \(message)")
    }
}
