//
//  AvancedMerchants.h
//  Oobee
//
//  Created by KennyHo on 7/1/14.
//  Copyright (c) 2014 Geocomply. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <CoreData/CoreData.h>
#import "Merchant.h"
#define MOBILE_ALGORITHM @"mobile"


@interface AdvancedMerchants : NSManagedObject

@property (nonatomic, retain) NSString * callBackURLString;
@property (nonatomic, retain) NSString * proximityMethod;
@property (nonatomic, retain) NSString * algorithm;

@property (nonatomic, retain) NSString * merchantName;
@property (nonatomic, retain) NSString * merchantID;
@property (nonatomic, retain) NSDate * pairedOnDate;
@property (nonatomic, retain) NSDate * lastProximityCheckingDate;
@property (nonatomic, retain) NSString * deviceUID;
@property (nonatomic, retain) NSNumber*  isProximityCheckPending;
@property (nonatomic, retain) NSDate * lastProximityRequestedOn;

//Get the merchant by ID
+(AdvancedMerchants *)getMerchantWithID:(NSString *)merchantID
                                  Error:(NSError **) error;

//Get the merchant by deviceUID
+(AdvancedMerchants *)getMerchantWithDeviceUID:(NSString *)deviceUID
                                         Error:(NSError **) error;

//Insert the merchant with ID
+(AdvancedMerchants *)insertNewMerchantWithID:(NSString *)merchantID
                                        Error:(NSError **) error;

/**
 *    Insert a new merchant with DUID
 *
 *    @param DUID device uid
 *
 *    @return return the reference to inserted merchant
 */
+(AdvancedMerchants *)insertNewMerchantWithDUID:(NSString *)DUID
                                          Error:(NSError **) error;

//Insert the merchant with more information
+(AdvancedMerchants *)insertMerchantWithID:(NSString *)merchantID
                                      name:(NSString *)merchantName
                              pairedOnDate:(NSDate *)pairDate
                 lastProximityCheckingDate:(NSDate *)proximityCheckingDate
                                 deviceUid:(NSString*) deviceUid
                                     Error:(NSError **) error;

//Remove the merchant by ID
+(void)removeMerchantWithID:(NSString *)merchantID
                      Error:(NSError **) error;

//Get all ther merchants
+(NSArray *)getAllMerchants :(NSError **) error;

//Remove all the merchant in DB
+(void)removeAllMerchants :(NSError **) error;

//Get the number of pending proximity request
+(long) getNumberOfPendingProximityMerchants :(NSError **) error;

//Get the number of merchants on DB
+(long) getnumberOfMerchant :(NSError **) error;

//Get all the pending proximity request
+(NSArray*) getPendingProximityMerchants :(NSError **) error;
//Convert advanceMerchant to Merchant
+(Merchant *)getMerchantFromAdvancedMerchant:(AdvancedMerchants *)advancedMerchant;


@end
