//
//  CommunicationController+Helpers.h
//  OobeeLibrary
//
//  Created by Hao Nguyen on 8/21/15.
//  Copyright (c) 2015 Geocomply. All rights reserved.
//

#import "CommunicationController.h"

@interface CommunicationController (Helpers)

- (void)processRegisterRequestWithRequesterObject:(RequesterObject*)requesterObject shouldRemoveAllMerchants:(BOOL)shouldRemove;

- (void)processUnPairRequestWithRequesterObject:(RequesterObject*)requesterObject;

- (void)processSynchronizeDatabaseRequestWithRequesterObject:(RequesterObject*)requesterObject andResponseData:(id)responseData;

- (NSError*)processProximitySubmitRequestWithRequesterObject:(RequesterObject*)requesterObject andResponseData:(id)responseData;

- (void)processGetPayLoadWithResponseData:(id)responseData fromURL:(NSURL*)fromURL;

- (NSError*)processRequestProximityPayloadWithRequesterObject:(RequesterObject*)requesterObject andResponseData:(id)responseData;

- (NSError*)processPairRequestWithRequesterObject:(RequesterObject*)requesterObject andResponseData:(id)responseData;

- (void)updateUIWithRequesterObject:(RequesterObject*)requesterObject error:(NSError*)error merchant:(Merchant*)merchant;

@end
