//
//  Error.h
//  OobeeLibrary
//
//  Created by geotech on 10/30/14.
//  Copyright (c) 2014 Geocomply. All rights reserved.
//

#ifndef OobeeLibrary_Error_h
#define OobeeLibrary_Error_h

#define OobeeLibraryDomain @"OobeeLibraryDomain"
#define OobeeServerDomain  @"OobeeServerDomain"
#define UnknownDomain      @"UnknownDomain"
#pragma Oobee Library error
typedef enum {
    OobeeLibrary_NoError                            = 0,
    OobeeLibrary_WrongRequestURL                    = 128,
    OobeeLibrary_CannotConnectToGeoTechServer       = 129,
    OobeeLibrary_NoResponseFromGeoTechServer        = 130,
    OobeeLibrary_InvalidResponseFromGeoTechServer   = 131,
    OobeeLibrary_UnknownError              = 300,
    OobeeLibrary_InternalError             = 301,
    OobeeLibrary_NilAgrumentError          = 302,
    OobeeLibrary_InvalidArgrumentError     = 303,
    OobeeLibrary_WrongAPNFormat            = 304,
    OobeeLibrary_DuplicatedAPN             = 305,
    OobeeLibrary_InvalidLicense            = 306,
    OobeeLibrary_SocketUrl                 = 307,
    OobeeLibrary_MerchantIdNotFound        = 308,
    OobeeLibrary_ProximityIsNotRequired    = 309,
    OobeeLibrary_ProximityTimeout          = 310,
    OobeeLibrary_InvalidReturnFromServer   = 311,
    OobeeLibrary_CannotFindCallBackURL     = 312,
    OobeeLibrary_SamePushToken             = 320,
    OobeeLibrary_AlwaysNotGranted          = 321
}OobeeLibraryErrors;

#pragma Server Error
typedef enum {
    OobeeServer_DeviceWasNotRegister       = 10,
    OobeeServer_DeviceWasAlreadyPaired     = 11,
    OobeeServer_DeviceWasAlreadyRegistered = 12,
    OobeeServer_DeviceWasNotPaired         = 13,
    OobeeServer_DeviceUUIDNotExist         = 14,
    OobeeServer_DeviceProximityRequired    = 15,
    OobeeServer_DeviceProximityNotRequired = 16,
    OobeeServer_PairCodeFailed             = 18,
    OobeeServer_PairCodeExpired            = 19,
    OobeeServer_PairCodeInvalid            = 20,
    OobeeServer_InvaliedTransaction        = 21,
    OobeeServer_APNServerError             = 56,
    OobeeServer_APNMessageError            = 57,
    OobeeServer_InvalidRequestData         = 91,
    OobeeServer_InvalidRequestId           = 92,
    OobeeServer_InternalError              = 99,
    OobeeServer_NoResponseData             = 100,
    OobeeServer_InvalidResponseData        = 101
}OobeeServerErrors;
#endif
