//
//  Setting.h
//  Oobee
//
//  Created by geotech on 6/13/14.
//  Copyright (c) 2014 Geocomply. All rights reserved.
//

#ifndef Oobee_Setting_h
#define Oobee_Setting_h
#define updateInternetTimeval 3

//Define the server response code
enum serverResponseCode{
 response_unknownCode             =      -1,
 response_success                 =      0,
 response_deviceWasNotRegistered  =      10,
 response_deviceWasPaired         =      11,
 response_deviceWasRegistered     =      12,
 response_deviceWasNotPair        =      13,
 response_invalidRequestData      =      91,
 response_serverInternalError     =      99,
 response_invalidPairCode         =      20,
 response_invalidTransactionId    =      21
};

#if DEBUG
// ***** IMPORTANT *****    No slash at the end of URL ***** IMPORTANT *****
//#define guvnr_server_url                          @"http://192.168.1.123:6060"
#define guvnr_server_url                          @"https://qat-oobee-440.geocomply.net"
//#define guvnr_server_url                        @"https://geotech-test.geocomply.net:3000"
//#define guvnr_server_url                        @"https://us3-uat-oobee.geocomply.net"    // US3 UAT
//#define guvnr_server_url                        @"https://us3-stg-oobee.geocomply.net"    // US3 Staging
//#define guvnr_server_url                        @"https://us3-oobee.geocomply.com"        // Production
#else
//#define guvnr_server_url                          @"https://geotech-test.geocomply.net:3000"
//#define guvnr_server_url                          @"https://us3-stg-oobee.geocomply.net"
#define guvnr_server_url                        @"https://qat-oobee-440.geocomply.net"
//#define guvnr_server_url                        @"https://oobee-test.geocomply.net:3000"
//#define guvnr_server_url                        @"https://us3-oobee.geocomply.com"
//#define guvnr_server_url                        @"https://us3-uat-oobee.geocomply.net"
#endif

#define payload_url                             @"payload"
#define pair_code_url                           guvnr_server_url@"/device/verify"
#define register_url                            guvnr_server_url@"/device/register"
#define synchronize_url                         guvnr_server_url@"/device/info"
#define request_proximity_payload_url           guvnr_server_url@"/device/proximity"

#define PUT                                     @"PUT"
#define POST                                    @"POST"
#define GET                                     @"GET"
#define DELETE                                  @"DELETE"
#define api_version                             @"1.0"

//The key for app seting
#define deviceTokenKey @"deviceTokenKey"


typedef enum
{
    FirstPair, // == 0 (by default)
    ProximityPair,
}PairType;


typedef enum
{
    RegisterRequest, // == 0 (by default)
    PairRequest,
    UnPairRequest,
    ProximitySubmit,
    GetPayload,
    SubmitGeolocation,
    SynchronizeDatabase,
    RequestProximityPayload,
}RequestType;

typedef enum {
    PP_UNKNOWN = 0,
    PP_PAIR = 100,
    PP_PROXIMITY = 101
}PairPurpose;


#endif
